import pandas as pd
from matplotlib import pyplot as plt

plt.style.use("seaborn")

data = pd.read_csv("data.csv")
ages = data['Age']
dev_salaries = data['All_Devs']
py_salaries = data['Python']
js_salaries = data['JavaScript']

plt.figure(1)

plt.plot(ages, py_salaries, label="Python")
plt.plot(ages, js_salaries, label="JavaScript")
plt.plot(ages, dev_salaries, color="#444444",
            linestyle="--", label="All Devs")

plt.legend()

plt.title("Median Salary (USD) by Age")
plt.xlabel("Ages")
plt.ylabel("Median salary (USD)")

plt.tight_layout()
plt.show()

